/**
 * @package JCE VM Product 2.1.0 by Shemzone - Frdric Chamsseddine
 * @copyright Copyright (C) 2005 - 2010 Ryan Demmer. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see licence.txt
 * JCE VM Product is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
(function() {
	var each = tinymce.each;
	
	tinymce.PluginManager.requireLangPack('vmproduct');
	
	tinymce.create('tinymce.plugins.WFVMProductPlugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('mcevmproductPopup', function() {
				ed.windowManager.open({
					file : ed.getParam('site_url') + 'index.php?option=com_jce&view=editor&layout=plugin&plugin=vmproduct',
					width : 560 + parseInt(ed.getLang('vmproduct.delta_width', 0)),
					height : 520 + parseInt(ed.getLang('vmproduct.delta_height', 0)),
					inline : 1,
					popup_css : false
				}, {
					plugin_url : url
				});
			});

			// Register buttons
			ed.addButton('vmproduct', {
				title : 'vmproduct.desc',
				cmd : 'mcevmproductPopup',
				image : url + '/img/vmproduct.png'
			});
		},

		getInfo : function() {
			return {
				longname : 'VM Product Plugin for JCE 2',
				author : 'Frederic Chamsseddine',
				authorurl : 'http://www.bookshop-virtuemart.net',
				infourl : 'http://www.bookshop-virtuemart.net',
				version : '2.1.0'
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('vmproduct', tinymce.plugins.WFVMProductPlugin);
})();