/**
 * @package JCE VM Product 2.1.0 by Shemzone - Frdric Chamsseddine
 * @copyright Copyright (C) 2005 - 2010 Ryan Demmer. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see licence.txt
 * JCE VM Product is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
var VMProductDialog = {
	settings : {},
	
	init : function() {
		var ed = tinyMCEPopup.editor, self = this;
		tinyMCEPopup.resizeToInnerSize();
		
		$.Plugin.init();
		ed.dom.show(document.body);
		$('#update').button('option', 'label', tinyMCEPopup.getLang('update', 'Update', true)).click( function(e) {
			self.onInsert();
			e.preventDefault();
		});
		$('#insert').click( function(e) {
			self.onInsert();
			e.preventDefault();
		});

		$('button#help').click( function(e) {
			$.Plugin.help('vmproduct');
			e.preventDefault();
		});
		
		$('button#cancel').click( function(e) {
			self.onClose();
		});		
		$.Plugin.setDefaults(this.settings.defaults);
	},
	
	onInsert : function() {
		var required = { 
		}; 
		for (var i in required) {
		  var el = document.getElementById(i);
		  if (!el.value) {
			alert(required[i]);
			el.focus();
			return false;
		  }
		}
		var myProduct = document.getElementById("i_product_id").value;
		if (myProduct !=""){
			this.insertVMProduct(myProduct);
			return true;
		}else{
			$.Dialog.alert(tinyMCEPopup.getLang('vmproduct_dlg.noproductselected'));
			return false;
		}
	},	
	
	/*Usage: {vmproduct:id=XX,showname=y,showprice=n,showdesc=n,showdescmode=s,showaddtocart=y,displayeach=h,displaylist=v,width=90%,border=0,style=color:black;,align=left, showimage=y,showfullimage=y,layout=hl,textwrap=y}
	*/
	
	insertVMProduct : function (product_id) {
		// pass data back to the calling window
		var fields = ["i_showname", "i_showprice", "i_showdesc", "i_showdescmode", "i_showaddtocart", "i_showimage", "i_fullimage", "i_align", "i_width", "i_width_unit", "i_border", "i_color", "i_displayeach", "i_displaylist", "i_product_id", "i_layout", "i_textwrap"];
		var param = new Object();
		var myresult="";
		for (var i in fields) {
		  var id = fields[i];
		  var el = document.getElementById(id);
		  param[id] = el.value;
		  //myresult +=id+"=>"+param[id]+"\n";
		}
		//alert(myresult);
		
		var html = "{vmproduct:id="+param.i_product_id+",";
		html += "showname=";
		html += (param.i_showname.toString()=="1") ? "y" : "n";
		html += ",";
		html += "showprice=";
		html += (param.i_showprice.toString()=="1") ? "y" : "n";
		html += ",";
		html += "showdesc=";
		html += (param.i_showdesc.toString()=="1") ? "y" : "n";
		html += ",";
		html += "showdescmode=";
		html += (param.i_showdescmode.toString()=="1") ? "s" : "l";
		html += ",";
		html += "showaddtocart=";
		html += (param.i_showaddtocart.toString()=="1") ? "y" : "n";
		html += ",";
		html += "displayeach=";
		html += (param.i_displayeach.toString()=="1") ? "h" : "v";
		html += ",";							  	  
		html += "displaylist=";
		html += (param.i_displaylist.toString()=="1") ? "h" : "v";
		if((param.i_width=='') || (isNaN(param.i_width*1)==true) || (param.i_fullimage.toString()=="1")) {
			html += ",";	
		} else{
			html += ",";		
			if ((param.i_width >100) && (param.i_width_unit.toString() == "0")) {
				$.Dialog.alert(tinyMCEPopup.getLang('vmproduct_dlg.widthtoolarge'));
				document.getElementById("i_width").value=100;
				return false;
				html += "width=100%";			
			} else {
				html += "width="+param.i_width;
				html += (param.i_width_unit.toString()=="0") ? "%" : "px";
			}
			html += ",";	
		}

		if((param.i_border=='') || (isNaN(param.i_border*1)==true)) {
			html += "border=0";
		} else{
			html += "border="+param.i_border;		
		}
		html += ",";
		html += "style=color:"+param.i_color+";";
		html += ",";
		if(param.i_align!='default'){
			html += "align="+param.i_align;
			html += ",";
		}
		html += "showimage=";
		html += (param.i_showimage.toString()=="1") ? "y" : "n";
		html += ",";							  
		html += "showfullimage=";
		html += (param.i_fullimage.toString()=="1") ? "y" : "n";
		html += ",";

		html += "layout=";
		switch(param.i_layout.toString()){
		case "0":
			html +="hl";
			break
		case "1":
			html +="hr";
			break
		case "2":
			html +="vl";
			break			
		case "3":
			html +="vr";
			break
		}
		html += ",";

		html += "textwrap=";
		html += (param.i_textwrap.toString()=="1") ? "y" : "n";	  

		html += "}";	
		//alert(html);
		//return false;
		tinyMCE.execCommand('mceInsertContent', false, html);
		tinyMCEPopup.close();
	},
	onClose : function () {
		tinyMCEPopup.close();
		return false;
	},
	
	openHelp : function() {
		$.Plugin.help('vmproduct');
	}
};
tinyMCEPopup.requireLangPack();
tinyMCEPopup.onInit.add(VMProductDialog.init, VMProductDialog);