<?php
/**
 * @copyright    Copyright (C) 2009 Nicholas K. Dionysopoulos. All rights reserved.
 * @author		Aazam
 * @license      GNU/GPL v.2 or later
 * 
 * flexicontentlinks is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 *
 * Based on "joomlalinks" found in JCE's core distribution, and flexicontentlinks by Emmanuel Dannan and Ryan Demmer
 */

defined( '_WF_EXT' ) or die( 'ERROR_403' );

class FlexicontentlinksItems extends JObject
{
	var $_option = 'com_flexicontent_items';
	
	/**
	* Constructor activating the default information of the class
	*
	* @access	protected
	*/
	function __construct($options = array()){
	}

	/**
	 * Returns a reference to a editor object
	 *
	 * This method must be invoked as:
	 * 		<pre>  $browser =JContentEditor::getInstance();</pre>
	 *
	 * @access	public
	 * @return	JCE  The editor object.
	 * @since	1.5
	 */
	function &getInstance()
	{
		static $instance;

		if ( !is_object( $instance ) ){
			$instance = new FlexicontentlinksItems();
		}
		return $instance;
	}
	
	public function getOption()
	{
		return $this->_option;
	}
	

	public function getList()
	{
		$advlink = WFEditorPlugin::getInstance();
		$list = '';
		if ($advlink->checkAccess('flexicontentlinks.items', '1')) {
			return  '<li id="index.php?option=com_flexicontent_items&view=category&cid=1"><div class="tree-row"><div class="tree-image"></div><span class="folderflexicontent nolink"><a href="javascript:;">' . JText::_('FLEXIcontent') . '</a></span></div></li>';
		}
		return $list;	
	}
	
	
	public function getLinks($args)
	{		
		$view		= isset($args->view) ? $args->view : '';
		if (!$view='category') {return array();}
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');
		
		$items 		= array();
		$CategoryId = $args->cid;
		
		//adding categoryes
		$db		=& JFactory::getDBO();
		$query	= $db->getQuery(true);
		$query->clear();
		$query->select('id, title, lft, CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(\':\', id, alias) ELSE id END as slug');
		$query->from('#__categories');
		$query->where('published = 1 AND extension = \'com_content\' AND parent_id = '.$CategoryId);
		$query->order('lft ASC');
		$db->setQuery($query);
		$categories = $db->loadObjectList();

		foreach ($categories as $category) {
			$items[] = array(
				'url'	=>	FlexicontentHelperRoute::getCategoryRoute($category->slug),
				'id'	=> 'index.php?option=com_flexicontent_items&view=category&cid='.$category->id,
				'name'	=>	$category->title,
				'class'	=>	'folderflexiitems'
			);
		}
		
		//adding items
		
		$query->clear();
		$query->select(' i.id as iid, i.title AS ititle, c.id as catid,'
				. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
				. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END as catslug');
		$query->from('#__content AS i'
				. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id '
				. ' LEFT JOIN #__categories AS c ON c.id = rel.catid ');
		$query->where('c.id = ' . $CategoryId);
		$query->order('i.title ASC');
		$db->setQuery($query);
		$contents = $db->loadObjectList();
		
		
		foreach ($contents as $content) {
			$items[] = array(
				'url'	=>	FlexicontentHelperRoute::getItemRoute($content->slug, $content->catslug),
				'id'	=>  'index.php?option=com_flexicontent_items&view=category&cid='.$category->id.'&id='.$content->iid,
				'name'	=>	$content->ititle.'(id='.$content->iid.')',
				'class'	=>	'fileflexiitems'
			);
		}

		return $items;
	}
	
}
?>