<?php
/**
* @package JCE Docman Links
* @copyright Copyright (C) 2005 - 2010 Ryan Demmer. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see licence.txt
* JCE Docman Links is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
defined('_WF_EXT') or die('Restricted access');
class DocmanlinksDocman extends JObject
{
	var $_option = 'com_docman';
	/**
	* Constructor activating the default information of the class
	 *
	 * @access	protected
	 */
	 function __construct($options = array())
	{
	}

	/**
	* Returns a reference to a editor object
	*
	* This method must be invoked as:
	* 		<pre>  $browser =JContentEditor::getInstance();</pre>
	*
	* @access	public
	* @return	JCE  The editor object.
	* @since	1.5
	*/
	function & getInstance()
	{
		static $instance;

		if (!is_object($instance)) {
			$instance = new DocmanlinksDocman();
		}
		return $instance;
	}
	function getOption()
	{
		return $this->_option;
	}
	function getList()
	{
		$wf = WFEditorPlugin::getInstance();

		if ($wf->checkAccess('links.docmanlinks.docman', 1)) {
			return '<li id="index.php?option=com_docman"><div class="tree-row"><div class="tree-image"></div><span class="folder docmanlinks nolink"><a href="javascript:;">'.JText::_('DOCMAN').'</a></span></div></li>';
        }
    }
	function getLinks($args){		
		global $_DOCMAN, $mainframe;
		
		$wf = WFEditorPlugin::getInstance();
		
		jimport('joomla.filesystem.file');

		require_once( JPATH_ADMINISTRATOR . DS. 'components' .DS. 'com_docman' .DS. 'docman.class.php');
		//DOCMan core interaction API
		$_DOCMAN = new dmMainFrame( _DM_TYPE_DOCLINK );

		// Load classes and language
	
		require_once( $_DOCMAN->getPath( 'classes', 'utils' ) );	
		$cid = isset( $args->gid ) ? $args->gid : 0;
		
		//get folders
        $categories = DOCMAN_Cats::getChildsByUserAccess( $cid );
        
		$items 	= array();
		$view	= isset($args->view) ? $args->view : '';
		
		switch($view){
			default:
				foreach( $categories as $category ){
					$items[] = array(
						'id'		=>	'index.php?option=com_docman&view=category&gid=' . $category->id . WFLinkBrowser::getItemId('com_docman'),
						'name'		=>	$category->name,
						'class'		=>	'folder docmanlinks'
					);
				}
				break;
			case 'category':
				//get items
				if( $cid ){
					$categories = DOCMAN_Cats::getChildsByUserAccess( $cid );
					$documents 	= DOCMAN_Docs::getDocsByUserAccess( $cid, 'name', 'ASC', 999, 0 );
				}else{
					$categories = array();
					$documents 	= array();
				}
				foreach( $categories as $category ){					
					$items[] = array(
						'id'		=>	'index.php?option=com_docman&view=category&gid=' . $category->id . WFLinkBrowser::getItemId('com_docman'),
						'name'		=>	$category->name,
						'class'		=>	'folder docmanlinks'
					);
				}
				foreach( $documents as $document ){										
					$items[] = array(
						'id'		=>	'index.php?option=com_docman&task=doc_'. $wf->getParam( 'docmanlinks_link', 'download' ) .'&gid=' . $document->id . WFLinkBrowser::getItemId('com_docman'),
						'name'		=>	$document->dmname,
						'class'		=>	'file docmanlinks '. JFile::getExt( $document->dmfilename )
					);
				}
				break;
		}
		return $items;
	}
}
?>