<?php
/**
* FLEXIcontent Advanced Link for JCE 2.1 (jce_advlink_flexi_1.5)
* @version		$Id: flexicontentlinks.php 001 2011-08-28 14:50:33Z Rehne $
* Based on "joomlalinks" found in JCE's core distribution. Modified by Rene Bz
* to support Flexicontent
* @author		Ryan Demmer
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Rene Bz
* copyright(C) 	Copyright (C) 2007 - 2011 Rene Bz - www.nettdotkomm.de
* @author		Emmanuel Danan
* @license      GNU/GPL
* JCE/FLEXIcontent Advanced Link is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined( '_WF_EXT' ) or die( 'ERROR_403' );

class WFLinkBrowser_Flexicontentlinks extends JObject
{
	
	var $_option 	= array();
	
	var $_adapters 	= array();
	
	/**
	* Constructor activating the default information of the class
	*
	* @access	protected
	*/
	function __construct($options = array()){
		jimport('joomla.filesystem.folder');
		jimport('joomla.filesystem.file');
				
		$path = dirname( __FILE__ ) .DS. 'flexicontentlinks';
		
		// Get all files
		$files = JFolder::files( $path, '\.(php)$' );
		
		if ( !empty( $files ) ) {
			foreach( $files as $file ) {
				require_once( $path .DS. $file );
				$classname = 'Flexicontentlinks' . ucfirst(basename($file, '.php'));
				$this->_adapters[] = new $classname;
			}
		}
	}
	
	/**
	 * Returns a reference to a editor object
	 *
	 * This method must be invoked as:
	 * 		<pre>  $browser =JContentEditor::getInstance();</pre>
	 *
	 * @access	public
	 * @return	JCE  The editor object.
	 * @since	1.5
	 */
	function &getInstance(){
		static $instance;

		if ( !is_object( $instance ) ){
			$instance = new WFLinkBrowser_Flexicontentlinks();
		}
		return $instance;
	}
	
	function display()
	{
		// Load css
		$document = WFDocument::getInstance();
		$document->addStyleSheet(array('flexicontentlinks'), 'extensions/links/flexicontentlinks/css');
	}
	
	function isEnabled() 
	{
		$wf = WFEditorPlugin::getInstance();
		return $wf->checkAccess($wf->getName() . '.links.flexicontentlinks.enable', 1);
	}
	
	function getOption()
	{
		foreach( $this->_adapters as $adapter ){
			$this->_option[]= $adapter->getOption();
		}
		return $this->_option;
	}
	
	function getList()
	{
		$list = '';
		
		foreach( $this->_adapters as $adapter ){
			$list .= $adapter->getList();
		}
		return $list;	
	}
	
	function getLinks( $args )
	{
		foreach( $this->_adapters as $adapter ){
			if( $adapter->getOption() == $args->option ){
				if(property_exists($args, 'task')) {
					$task = $args->task;
				} else {
					$task = 'category';
				}				
				if($adapter->getTask() == $task) {
					return $adapter->getLinks( $args );
				}
			}
		}
	}
}	
?>